/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model.armor;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.client.model.armor.ModelArmor;
import vazkii.botania.common.item.equipment.armor.elementium.ItemElementiumArmor;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;
import vazkii.botania.common.item.equipment.armor.manaweave.ItemManaweaveArmor;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelArmor;

public class ArmorModels {
    private static Map<EquipmentSlot, ModelArmor> manasteel = Collections.emptyMap();
    private static Map<EquipmentSlot, ModelArmor> manaweave = Collections.emptyMap();
    private static Map<EquipmentSlot, ModelArmor> elementium = Collections.emptyMap();
    private static Map<EquipmentSlot, ModelArmor> terrasteel = Collections.emptyMap();

    private static Map<EquipmentSlot, ModelArmor> make(EntityRendererProvider.Context ctx, ModelLayerLocation inner, ModelLayerLocation outer) {
        EnumMap<EquipmentSlot, ModelArmor> ret = new EnumMap<EquipmentSlot, ModelArmor>(EquipmentSlot.class);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ModelPart mesh = ctx.m_174023_(slot == EquipmentSlot.LEGS ? inner : outer);
            ret.put(slot, new ModelArmor(mesh, slot));
        }
        return ret;
    }

    public static void init(EntityRendererProvider.Context ctx) {
        manasteel = ArmorModels.make(ctx, ModModelLayers.MANASTEEL_INNER_ARMOR, ModModelLayers.MANASTEEL_OUTER_ARMOR);
        manaweave = ArmorModels.make(ctx, ModModelLayers.MANAWEAVE_INNER_ARMOR, ModModelLayers.MANAWEAVE_OUTER_ARMOR);
        elementium = ArmorModels.make(ctx, ModModelLayers.ELEMENTIUM_INNER_ARMOR, ModModelLayers.ELEMENTIUM_OUTER_ARMOR);
        terrasteel = ArmorModels.make(ctx, ModModelLayers.TERRASTEEL_INNER_ARMOR, ModModelLayers.TERRASTEEL_OUTER_ARMOR);
    }

    @Nullable
    public static ModelArmor get(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ItemManaweaveArmor) {
            ItemManaweaveArmor armor = (ItemManaweaveArmor)item;
            return manaweave.get(armor.m_40402_());
        }
        if (item instanceof ItemElementiumArmor) {
            ItemElementiumArmor armor = (ItemElementiumArmor)item;
            return elementium.get(armor.m_40402_());
        }
        if (item instanceof ItemTerrasteelArmor) {
            ItemTerrasteelArmor armor = (ItemTerrasteelArmor)item;
            return terrasteel.get(armor.m_40402_());
        }
        if (item instanceof ItemManasteelArmor) {
            ItemManasteelArmor armor = (ItemManasteelArmor)item;
            return manasteel.get(armor.m_40402_());
        }
        return null;
    }
}

